unit OptionsFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, RVStyle;

type
  TfrmOptions = class(TForm)
    btnOk: TButton;
    btnCancel: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    GroupBox1: TGroupBox;
    cbRVFSaveBackground: TCheckBox;
    cbRVFSaveLayout: TCheckBox;
    cbRVFBinary: TCheckBox;
    cbRVFSavePictures: TCheckBox;
    cbRVFSaveControls: TCheckBox;
    GroupBox2: TGroupBox;
    cbRVFLoadBackground: TCheckBox;
    cbRVFLoadLayout: TCheckBox;
    cbRVFIgnoreUnknownPictures: TCheckBox;
    cbRVFIgnoreUnknownControls: TCheckBox;
    cbRVFInvStyles: TCheckBox;
    cbRVFInvImageIndices: TCheckBox;
    TabSheet3: TTabSheet;
    GroupBox3: TGroupBox;
    cbHTMLOverrideImages: TCheckBox;
    cbHTMLListAsTest: TCheckBox;
    cbHTMLForceNonTextCSS: TCheckBox;
    cbHTMLDefault0Style: TCheckBox;
    cbHTMLSaveImageSizes: TCheckBox;
    cbHTMLNoHypertextImageBorders: TCheckBox;
    cbHTMLUseCheckpointsNames: TCheckBox;
    txtHTMLTitle: TEdit;
    Label1: TLabel;
    cbRVFSaveTextStyles: TCheckBox;
    cbRVFSaveParaStyles: TCheckBox;
  private
    { Private declarations }
  public
    { Public declarations }
    procedure SetOptions(RVFOptions: TRVFOptions; HTMLOptions: TRVSaveOptions;
      const HTMLTitle: String);
    procedure GetOptions(var RVFOptions: TRVFOptions; var HTMLOptions: TRVSaveOptions;
      var HTMLTitle: String);
  end;

var
  frmOptions: TfrmOptions;

implementation

{$R *.dfm}

{ TfrmOptions }

procedure TfrmOptions.GetOptions(var RVFOptions: TRVFOptions;
  var HTMLOptions: TRVSaveOptions; var HTMLTitle: String);
  {..........................................................}
  procedure SetRVFOption(Value: Boolean; Option: TRVFOption);
  begin
    if Value then
      RVFOptions := RVFOptions + [Option]
    else
      RVFOptions := RVFOptions - [Option];
  end;
  {..........................................................}
  procedure SetHTMLOption(Value: Boolean; Option: TRVSaveOption);
  begin
    if Value then
      HTMLOptions := HTMLOptions + [Option]
    else
      HTMLOptions := HTMLOptions - [Option];
  end;
  {..........................................................}
begin
  RVFOptions := [];
  HTMLOptions := [];
  SetRVFOption(cbRVFSaveBackground.Checked, rvfoSaveBack);
  SetRVFOption(cbRVFSaveLayout.Checked,     rvfoSaveLayout);
  SetRVFOption(cbRVFBinary.Checked,         rvfoSaveBinary);
  SetRVFOption(cbRVFSavePictures.Checked,   rvfoSavePicturesBody);
  SetRVFOption(cbRVFSaveControls.Checked,   rvfoSaveControlsBody);
  SetRVFOption(cbRVFLoadBackground.Checked, rvfoLoadBack);
  SetRVFOption(cbRVFLoadLayout.Checked,     rvfoLoadLayout);
  SetRVFOption(cbRVFIgnoreUnknownPictures.Checked , rvfoIgnoreUnknownPicFmt);
  SetRVFOption(cbRVFIgnoreUnknownControls.Checked , rvfoIgnoreUnknownCtrls);
  SetRVFOption(cbRVFInvStyles.Checked,              rvfoConvUnknownStylesToZero);
  SetRVFOption(cbRVFInvImageIndices.Checked,        rvfoConvLargeImageIdxToZero);
  SetRVFOption(cbRVFSaveTextStyles.Checked,  rvfoSaveTextStyles);
  SetRVFOption(cbRVFSaveParaStyles.Checked,  rvfoSaveParaStyles);

  SetHTMLOption(cbHTMLOverrideImages.Checked, rvsoOverrideImages);
  SetHTMLOption(cbHTMLListAsTest.Checked, rvsoMarkersAsText);
  SetHTMLOption(cbHTMLForceNonTextCSS.Checked, rvsoForceNonTextCSS);
  SetHTMLOption(cbHTMLDefault0Style.Checked, rvsoDefault0Style);
  SetHTMLOption(cbHTMLSaveImageSizes.Checked, rvsoImageSizes);
  SetHTMLOption(cbHTMLNoHypertextImageBorders.Checked, rvsoNoHypertextImageBorders);
  SetHTMLOption(cbHTMLUseCheckpointsNames.Checked, rvsoUseCheckpointsNames);

  HTMLTitle := txtHTMLTitle.Text;
end;
{------------------------------------------------------------------------------}
procedure TfrmOptions.SetOptions(RVFOptions: TRVFOptions;
  HTMLOptions: TRVSaveOptions; const HTMLTitle: String);
begin
  cbRVFSaveBackground.Checked := rvfoSaveBack         in RVFOptions;
  cbRVFSaveLayout.Checked     := rvfoSaveLayout       in RVFOptions;
  cbRVFBinary.Checked         := rvfoSaveBinary       in RVFOptions;
  cbRVFSavePictures.Checked   := rvfoSavePicturesBody in RVFOptions;
  cbRVFSaveControls.Checked   := rvfoSaveControlsBody in RVFOptions;
  cbRVFLoadBackground.Checked := rvfoLoadBack         in RVFOptions;
  cbRVFLoadLayout.Checked     := rvfoLoadLayout       in RVFOptions;
  cbRVFIgnoreUnknownPictures.Checked := rvfoIgnoreUnknownPicFmt in RVFOptions;
  cbRVFIgnoreUnknownControls.Checked := rvfoIgnoreUnknownCtrls  in RVFOptions;
  cbRVFInvStyles.Checked      := rvfoConvUnknownStylesToZero    in RVFOptions;
  cbRVFInvImageIndices.Checked := rvfoConvLargeImageIdxToZero   in RVFOptions;
  cbRVFSaveTextStyles.Checked := rvfoSaveTextStyles   in RVFOptions;
  cbRVFSaveParaStyles.Checked := rvfoSaveParaStyles   in RVFOptions;

  cbHTMLOverrideImages.Checked := rvsoOverrideImages   in HTMLOptions;
  cbHTMLListAsTest.Checked     := rvsoMarkersAsText    in HTMLOptions;
  cbHTMLForceNonTextCSS.Checked := rvsoForceNonTextCSS in HTMLOptions;
  cbHTMLDefault0Style.Checked  := rvsoDefault0Style    in HTMLOptions;
  cbHTMLSaveImageSizes.Checked := rvsoImageSizes       in HTMLOptions;
  cbHTMLNoHypertextImageBorders.Checked := rvsoNoHypertextImageBorders in HTMLOptions;
  cbHTMLUseCheckpointsNames.Checked := rvsoUseCheckpointsNames in HTMLOptions;

  txtHTMLTitle.Text := HTMLTitle;
end;

end.
